/* 
 *  InteractionDetailsForm.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import javafx.collections.ObservableList;

public class InteractionDetailsForm extends DetailsForm {

    private static final Logger LOG = Logger.getLogger(InteractionDetailsForm.class);
    private final InteractionDataGUI gui;
    private final InteractionExecutor interactionExe;
    public InteractionDetailsForm(InteractionExecutor interactionExe, String css, InteractionDataGUI gui) {
        super(LOG, "Interaction Details", "Interaction Details", css);
        this.gui = gui;
        this.interactionExe= interactionExe;
    }

    @Override
    protected void action() {
        interactionExe.getInteractionData();
    }

    @Override
    protected ObservableList<Data> getItems() {
        return gui.getItems();
    }

    @Override
    protected Data getItem(String id) {
        return gui.getItem(id);
    }

    @Override
    protected Data getDefault() {
        return new InteractionData(null);
    }
}
